/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.event;

import dev.murad.shipping.item.SpringItem;
import dev.murad.shipping.util.EntitySpringAPI;
import dev.murad.shipping.util.LinkableEntity;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShearsItem;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="littlelogistics")
public class ForgeEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void entityInteract(PlayerInteractEvent.EntityInteract event) {
        ForgeEventHandler.handleEvent((PlayerInteractEvent)event, event.getTarget());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void entitySpecificInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        ForgeEventHandler.handleEvent((PlayerInteractEvent)event, event.getTarget());
    }

    private static void handleEvent(PlayerInteractEvent event, Entity target) {
        if (!event.getItemStack().m_41619_()) {
            Item item = event.getItemStack().m_41720_();
            if (item instanceof SpringItem) {
                SpringItem springItem = (SpringItem)item;
                if (EntitySpringAPI.isValidTarget(target)) {
                    springItem.onUsedOnEntity(event.getItemStack(), event.getPlayer(), event.getWorld(), target);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
            }
            if (item instanceof ShearsItem && target instanceof LinkableEntity) {
                LinkableEntity v = (LinkableEntity)target;
                v.handleShearsCut();
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }
}

